<?php
/**
 * @brief		GraphQL: Language query
 * @author		<a href='http://www.invisionpower.com'>Invision Power Services, Inc.</a>
 * @copyright	(c) 2001 - 2016 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/legal/standards/
 * @package		IPS Community Suite
 * @since		10 May 2017
 * @version		SVN_VERSION_NUMBER
 */

namespace IPS\core\api\GraphQL\Queries;
use IPS\Api\GraphQL\TypeRegistry;
use IPS\core\api\GraphQL\Types\LanguageType;
use IPS\Lang;
use IPS\Member;
use function defined;

/* To prevent PHP errors (extending class does not exist) revealing path */
if ( !defined( '\IPS\SUITE_UNIQUE_KEY' ) )
{
	header( ( $_SERVER['SERVER_PROTOCOL'] ?? 'HTTP/1.0' ) . ' 403 Forbidden' );
	exit;
}

/**
 * Me query for GraphQL API
 */
class Language
{

	/*
	 * @brief 	Query description
	 */
	public static string $description = "Return language data";

	/*
	 * Query arguments
	 */
	public function args(): array
	{
		return array(
			'id' => TypeRegistry::id()
		);
	}

	/**
	 * Return the query return type
	 */
	public function type() : LanguageType
	{
		return \IPS\core\api\GraphQL\TypeRegistry::language();
	}

	/**
	 * Resolves this query
	 *
	 * @param 	mixed $val 	Value passed into this resolver
	 * @param 	array $args 	Arguments
	 * @return	Lang
	 */
	public function resolve( mixed $val, array $args ) : Lang
	{
		if( isset( $args['id'] ) ){
			return Lang::load( $args['id'] );
		}

		return Member::loggedIn()->language();
	}
}
